<?php
require_once 'config.php';

// Simple authentication (you should implement proper session-based auth)
$headers = getallheaders();
$apiKey = isset($headers['Authorization']) ? str_replace('Bearer ', '', $headers['Authorization']) : null;

if ($apiKey !== API_KEY) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$method = $_SERVER['REQUEST_METHOD'];
$input = json_decode(file_get_contents('php://input'), true);

try {
    $conn = getDBConnection();
    
    switch ($method) {
        case 'PUT': // Update item
            if (!isset($input['item_id']) || !isset($input['price'])) {
                http_response_code(400);
                echo json_encode(['error' => 'Item ID and price are required']);
                exit;
            }
            
            $updates = [];
            $params = [];
            
            if (isset($input['price'])) {
                $updates[] = "price = ?";
                $params[] = $input['price'];
            }
            if (isset($input['item_name'])) {
                $updates[] = "item_name = ?";
                $params[] = $input['item_name'];
            }
            if (isset($input['description'])) {
                $updates[] = "description = ?";
                $params[] = $input['description'];
            }
            if (isset($input['is_available'])) {
                $updates[] = "is_available = ?";
                $params[] = $input['is_available'] ? 1 : 0;
            }
            if (isset($input['is_featured'])) {
                $updates[] = "is_featured = ?";
                $params[] = $input['is_featured'] ? 1 : 0;
            }
            
            $params[] = $input['item_id'];
            
            $sql = "UPDATE menu_items SET " . implode(", ", $updates) . " WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->execute($params);
            
            echo json_encode([
                'success' => true,
                'message' => 'Item updated successfully',
                'updated_at' => date('c')
            ]);
            break;
            
        case 'POST': // Add new item
            if (!isset($input['category_id']) || !isset($input['item_name']) || !isset($input['price'])) {
                http_response_code(400);
                echo json_encode(['error' => 'Category ID, item name, and price are required']);
                exit;
            }
            
            $stmt = $conn->prepare("
                INSERT INTO menu_items (category_id, item_name, description, price, image_url, is_available, is_featured)
                VALUES (?, ?, ?, ?, ?, ?, ?)
            ");
            
            $stmt->execute([
                $input['category_id'],
                $input['item_name'],
                $input['description'] ?? null,
                $input['price'],
                $input['image_url'] ?? null,
                isset($input['is_available']) ? ($input['is_available'] ? 1 : 0) : 1,
                isset($input['is_featured']) ? ($input['is_featured'] ? 1 : 0) : 0
            ]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Item added successfully',
                'item_id' => $conn->lastInsertId()
            ]);
            break;
            
        case 'DELETE': // Delete item
            if (!isset($input['item_id'])) {
                http_response_code(400);
                echo json_encode(['error' => 'Item ID is required']);
                exit;
            }
            
            $stmt = $conn->prepare("DELETE FROM menu_items WHERE id = ?");
            $stmt->execute([$input['item_id']]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Item deleted successfully'
            ]);
            break;
            
        default:
            http_response_code(405);
            echo json_encode(['error' => 'Method not allowed']);
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Server error: ' . $e->getMessage()]);
}
?>
