# Quick Start Guide - Test in 5 Minutes! 🚀

## Fastest Way to Test (Local Testing)

### Option 1: Using PHP Built-in Server (Easiest)

1. **Navigate to project folder:**
   ```bash
   cd digital-menu-system
   ```

2. **Start PHP server:**
   ```bash
   php -S localhost:8000
   ```

3. **Setup Database:**
   - Create database in phpMyAdmin or MySQL:
     ```sql
     CREATE DATABASE digital_menu_db;
     ```
   - Import: `database/setup.sql`
   - Edit `api/config.php` with your database credentials

4. **Test URLs:**
   - Admin: http://localhost:8000/admin/
   - TV Display: http://localhost:8000/display/?board=demo-main-board

### Option 2: Upload to Your Hosting

1. **Upload all files** to your web server via FTP/cPanel

2. **Create database:**
   - Use cPanel or phpMyAdmin
   - Import `database/setup.sql`

3. **Edit `api/config.php`:**
   ```php
   define('DB_USER', 'your_username');
   define('DB_PASS', 'your_password');
   define('API_KEY', 'change_this_secret_key');
   ```

4. **Edit `assets/js/admin.js` line 5:**
   ```javascript
   this.apiKey = 'change_this_secret_key'; // Match config.php
   ```

5. **Access:**
   - Admin: https://yourdomain.com/digital-menu/admin/
   - TV: https://yourdomain.com/digital-menu/display/?board=demo-main-board

## First Time Setup Checklist ✅

- [ ] Database created and setup.sql imported
- [ ] api/config.php configured with DB credentials
- [ ] API_KEY changed in both config.php and admin.js
- [ ] Tested admin dashboard loads
- [ ] Tested TV display shows menu
- [ ] Tried editing a menu item price

## Demo Data Included

The system comes with:
- ✅ 1 Demo Restaurant
- ✅ 4 Categories (Appetizers, Mains, Desserts, Beverages)
- ✅ 7 Menu Items
- ✅ 1 Happy Hour Schedule (Buffalo Wings, Mon-Fri 4-6pm)

## Testing the System

### Test 1: View the Menu
1. Open TV display: `display/?board=demo-main-board`
2. You should see a beautiful menu with categories and items
3. Clock should show current time
4. Last updated timestamp at bottom

### Test 2: Edit a Price
1. Open admin: `admin/`
2. Find "Buffalo Wings" ($12.99)
3. Click edit icon ✏️
4. Change price to $14.99
5. Save
6. Wait 30 seconds or refresh TV display
7. Price should update!

### Test 3: Test Scheduled Pricing
1. Set your computer time to Monday-Friday between 4:00 PM - 6:00 PM
2. Refresh TV display
3. Buffalo Wings should show $9.99 with "Happy Hour Special" badge
4. Original price $12.99 should show crossed out

### Test 4: Add New Item
1. In admin, click "+ Add Menu Item"
2. Fill form:
   - Category: Appetizers
   - Name: "Nachos Supreme"
   - Description: "Loaded with cheese and jalapeños"
   - Price: 10.99
   - Available: ✓
   - Featured: ✓
3. Save
4. Check TV display - new item appears!

## Smart TV Setup

### For Samsung Smart TV:
1. Open Internet Browser app
2. Enter URL: `https://yourdomain.com/digital-menu/display/?board=demo-main-board`
3. Press Tools → Settings → Delete browsing data (to clear cache)
4. Reload page
5. Press Exit to hide browser controls (or enable Kiosk mode if available)

### For LG webOS TV:
1. Open Web Browser
2. Enter URL
3. Press Settings → Clear browsing data
4. For fullscreen: Use TV's zoom/aspect ratio settings

### General Tips:
- Bookmark the display URL for easy access
- Disable TV sleep mode: Settings → Power → Sleep Timer → Off
- Set TV to auto-start browser on power-on (if available)
- Use screensaver prevention: The display auto-refreshes every 30 seconds

## Common Issues & Fixes

### "Board not found" error
- Check board slug in URL matches database
- Default slug: `demo-main-board`

### Items not updating
- Check API_KEY matches in config.php and admin.js
- Look at browser console for errors (F12)
- Verify database connection

### Blank screen on TV
- Check internet connection
- Try different browser on TV
- Clear TV browser cache
- Check if URL is correct

### Can't add/edit items
- Open browser console (F12)
- Check for errors
- Verify PHP version is 7.4+
- Check database permissions

## File You Need to Edit

### Required Changes:
1. **api/config.php** - Lines 3-5 (Database credentials)
2. **api/config.php** - Line 9 (API_KEY)
3. **assets/js/admin.js** - Line 5 (API_KEY must match)

### Optional Changes:
- Theme colors in database
- Refresh interval
- Business name

## What's Working Now (Phase 1)

✅ Menu display on TV  
✅ Real-time price updates  
✅ Admin dashboard  
✅ Add/Edit/Delete items  
✅ Schedule pricing (happy hour)  
✅ Featured items  
✅ Availability toggle  
✅ Offline mode  
✅ Auto-refresh  

## What's Coming Next (Phase 2)

🔜 Canva-like drag & drop editor  
🔜 Custom animations  
🔜 Image uploads  
🔜 Multiple boards  
🔜 Advanced scheduling  
🔜 User authentication  

## Need Help?

1. Read README.md for detailed documentation
2. Check browser console (F12) for errors
3. Check PHP error logs
4. Verify all files uploaded correctly

---

**You're all set!** 🎉 Start by testing the admin dashboard and TV display with the demo data.
