# Digital Menu Board System - Phase 1

A professional digital menu board system for restaurants with real-time price updates, scheduled pricing, and offline capability.

## Features ✨

### Current (Phase 1)
- ✅ Real-time menu display optimized for 55" TVs (1920x1080)
- ✅ Admin dashboard for managing menu items
- ✅ Scheduled price changes (Happy Hour, Lunch Specials, etc.)
- ✅ Multi-category menu organization
- ✅ Featured items and availability management
- ✅ Offline capability with service workers
- ✅ Auto-refresh with configurable intervals
- ✅ Beautiful gradient themes
- ✅ Responsive design

### Coming Soon (Phase 2+)
- 🔜 Canva-like drag-and-drop editor
- 🔜 Custom animations and transitions
- 🔜 Multiple board management
- 🔜 Image upload functionality
- 🔜 Advanced scheduling options
- 🔜 Analytics dashboard
- 🔜 Multi-user support with roles

## Installation 🚀

### Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx)
- Modern web browser (for Smart TV display)

### Step 1: Database Setup

1. Create a MySQL database:
```sql
CREATE DATABASE digital_menu_db CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

2. Import the database schema:
```bash
mysql -u your_username -p digital_menu_db < database/setup.sql
```

Or run the SQL script through phpMyAdmin.

### Step 2: Configuration

1. Edit `api/config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_db_user');        // Change this
define('DB_PASS', 'your_db_password');    // Change this
define('DB_NAME', 'digital_menu_db');
define('API_KEY', 'your_secret_api_key'); // Change this!
define('TIMEZONE', 'America/New_York');   // Set your timezone
```

2. Update the API_KEY in `assets/js/admin.js`:
```javascript
this.apiKey = 'your_secret_api_key'; // Must match config.php
```

### Step 3: Upload Files

Upload all files to your web server. Your directory structure should look like:

```
your-domain.com/digital-menu/
├── admin/
│   └── index.html
├── display/
│   └── index.html
├── api/
│   ├── config.php
│   ├── get-menu.php
│   └── update-menu.php
├── assets/
│   ├── css/
│   │   ├── admin.css
│   │   └── display.css
│   └── js/
│       ├── admin.js
│       └── display.js
├── database/
│   └── setup.sql
└── sw.js
```

### Step 4: Test Installation

1. **Test Admin Dashboard:**
   Navigate to: `https://your-domain.com/digital-menu/admin/`
   
2. **Test TV Display:**
   Navigate to: `https://your-domain.com/digital-menu/display/?board=demo-main-board`

## Usage 📖

### Admin Dashboard

1. **Access:** `https://your-domain.com/digital-menu/admin/`

2. **Managing Menu Items:**
   - Click "+ Add Menu Item" to add new items
   - Click edit (✏️) icon on any item to modify
   - Click delete (🗑️) icon to remove items
   - Use filters to search and organize items

3. **Price Updates:**
   - Edit any item and change the price
   - Changes appear on TV displays within the refresh interval (default 30 seconds)

### TV Display Setup

1. **On Your Smart TV:**
   - Open the TV's web browser
   - Navigate to: `https://your-domain.com/digital-menu/display/?board=demo-main-board`
   - Press F11 or enable fullscreen mode
   - The menu will auto-refresh every 30 seconds

2. **URL Parameters:**
   - `?board=demo-main-board` - Specifies which board to display
   - You can create multiple boards for different locations/menus

### Scheduled Pricing (Happy Hour Example)

The demo data includes a Happy Hour schedule for Buffalo Wings:
- **Original Price:** $12.99
- **Happy Hour Price:** $9.99
- **Time:** Monday-Friday, 4:00 PM - 6:00 PM

When the schedule is active, the menu automatically shows:
- Discounted price in large text
- Original price with strikethrough
- "Happy Hour Special" badge

## Demo Credentials 🔐

The system comes pre-loaded with demo data:

- **Demo Business:** Demo Restaurant
- **Board Slug:** demo-main-board
- **Categories:** Appetizers, Main Courses, Desserts, Beverages
- **Sample Items:** Buffalo Wings, Classic Burger, Grilled Salmon, etc.

## Customization 🎨

### Changing Colors

Edit theme in the database (menu_boards table, theme_config column):
```json
{
  "primaryColor": "#FF6B35",
  "secondaryColor": "#F7931E",
  "fontFamily": "Poppins",
  "bgColor": "#1a1a1a"
}
```

### Adjusting Refresh Interval

1. Via Admin Dashboard: Settings → Refresh Interval
2. Via Database: Update `refresh_interval` in `menu_boards` table (value in seconds)

## Troubleshooting 🔧

### Menu Not Loading

1. Check database connection in `api/config.php`
2. Verify PHP error logs
3. Check browser console for JavaScript errors
4. Ensure board slug is correct in URL

### Can't Update Items

1. Verify API_KEY matches in both `config.php` and `admin.js`
2. Check PHP version (requires 7.4+)
3. Verify database permissions

### Display Issues on TV

1. Ensure TV browser supports modern JavaScript (ES6+)
2. Clear browser cache
3. Check internet connection
4. Try different browser if available

## Browser Support 🌐

- **TV Display:** Chrome 80+, Firefox 75+, Safari 13+, Edge 80+
- **Admin Dashboard:** All modern browsers

## Security Notes 🔒

**IMPORTANT:** Before going live:

1. Change the `API_KEY` in `config.php`
2. Update the `API_KEY` in `admin.js`
3. Disable error reporting in production:
   ```php
   error_reporting(0);
   ini_set('display_errors', 0);
   ```
4. Use HTTPS (SSL certificate)
5. Implement proper user authentication for admin panel
6. Restrict admin panel access by IP if possible

## File Structure 📁

```
digital-menu-system/
├── admin/              # Admin dashboard
├── display/            # TV display interface
├── api/                # Backend API endpoints
├── assets/
│   ├── css/           # Stylesheets
│   ├── js/            # JavaScript files
│   └── images/        # Image assets (future)
├── database/          # SQL schema
└── sw.js              # Service worker for offline support
```

## Next Steps 🚀

This is Phase 1 - Core functionality. Coming next:

**Phase 2:** Canva-like Editor
- Drag-and-drop design interface
- Custom animations and transitions
- Template library
- Visual theme customization

**Phase 3:** Advanced Features
- Image upload and management
- Multi-board dashboard
- User roles and permissions
- Advanced analytics

## Support 💬

For issues or questions:
1. Check this README
2. Review browser console for errors
3. Check PHP error logs
4. Verify database structure matches setup.sql

## License 📄

Custom built for restaurant digital signage needs.

---

**Version:** 1.0.0 (Phase 1)  
**Last Updated:** November 2025
