# Configuration Checklist 📋

Use this checklist to ensure everything is configured correctly.

## Pre-Installation

- [ ] PHP 7.4+ installed on server
- [ ] MySQL 5.7+ available
- [ ] FTP/cPanel access to hosting
- [ ] Domain or subdomain ready
- [ ] SSL certificate (recommended)

## Database Setup

- [ ] Created database: `digital_menu_db`
- [ ] Database user created with full permissions
- [ ] Imported `database/setup.sql` successfully
- [ ] Verified tables exist:
  - [ ] users
  - [ ] menu_boards
  - [ ] menu_categories
  - [ ] menu_items
  - [ ] price_schedules
  - [ ] design_templates
  - [ ] activity_logs
- [ ] Demo data loaded (7 menu items visible)

## File Configuration

### api/config.php
```php
// Update these lines:
define('DB_HOST', 'localhost');              // Usually 'localhost'
define('DB_USER', '_______________');        // Your DB username
define('DB_PASS', '_______________');        // Your DB password
define('DB_NAME', 'digital_menu_db');        // Keep as is
define('API_KEY', '_______________');        // Create random secret key
define('TIMEZONE', '_______________');       // Your timezone
```

- [ ] DB_HOST configured
- [ ] DB_USER configured
- [ ] DB_PASS configured
- [ ] DB_NAME verified
- [ ] API_KEY changed (use random string)
- [ ] TIMEZONE set (e.g., 'America/New_York')

### assets/js/admin.js
```javascript
// Line 5 - Update this:
this.apiKey = '_______________'; // MUST match API_KEY in config.php
```

- [ ] apiKey matches config.php API_KEY exactly

## File Upload

- [ ] All files uploaded to server
- [ ] Correct directory structure maintained
- [ ] File permissions set correctly (755 for directories, 644 for files)
- [ ] .htaccess file uploaded (if using Apache)

## Testing

### Database Connection Test
- [ ] Visit: `your-domain.com/digital-menu/api/get-menu.php?board=demo-main-board`
- [ ] Should return JSON with menu data (not blank or error)

### Admin Dashboard Test
- [ ] Visit: `your-domain.com/digital-menu/admin/`
- [ ] Page loads without errors
- [ ] Can see demo menu items (7 items in 4 categories)
- [ ] No console errors (press F12)

### TV Display Test
- [ ] Visit: `your-domain.com/digital-menu/display/?board=demo-main-board`
- [ ] Menu displays beautifully
- [ ] All 7 demo items visible
- [ ] Clock shows current time
- [ ] No console errors

### Update Test
- [ ] Open admin dashboard
- [ ] Click edit on "Buffalo Wings"
- [ ] Change price from $12.99 to $15.99
- [ ] Click Save
- [ ] Wait 30 seconds
- [ ] Refresh TV display
- [ ] New price shows: $15.99

### Add Item Test
- [ ] Click "+ Add Menu Item"
- [ ] Fill all required fields
- [ ] Click Save
- [ ] Item appears in admin list
- [ ] Item appears on TV display

## Production Setup (Before Going Live)

### Security
- [ ] Changed API_KEY to strong random string
- [ ] Disabled PHP error display in config.php:
  ```php
  error_reporting(0);
  ini_set('display_errors', 0);
  ```
- [ ] Using HTTPS (SSL certificate)
- [ ] Admin panel password protected (via .htaccess or server config)
- [ ] Database user has minimum required permissions

### Performance
- [ ] Tested on actual Smart TV browser
- [ ] Verified refresh interval works (default 30 seconds)
- [ ] Checked page load speed
- [ ] Tested offline capability
- [ ] Verified images load properly

### Smart TV Setup
- [ ] TV browser can access your website
- [ ] Bookmarked display URL on TV
- [ ] Set TV to fullscreen/kiosk mode
- [ ] Disabled TV sleep timer
- [ ] Tested auto-refresh works on TV

## Customization (Optional)

### Theme Colors
- [ ] Updated theme_config in menu_boards table
- [ ] Tested colors look good on TV
- [ ] Verified text is readable

### Refresh Interval
- [ ] Set to appropriate value (30-60 seconds recommended)
- [ ] Updated in menu_boards table

### Business Info
- [ ] Updated business_name in users table
- [ ] Updated board_name in menu_boards table

## Troubleshooting Reference

### If menu won't load:
1. Check database connection (config.php)
2. Verify board_slug is correct
3. Check PHP error logs
4. Test API endpoint directly

### If items won't update:
1. Verify API_KEY matches in both files
2. Check browser console for errors
3. Test with different browser
4. Check database permissions

### If TV display is blank:
1. Check TV has internet connection
2. Try accessing from computer first
3. Clear TV browser cache
4. Check URL is correct

## Support Checklist

Before asking for help, verify:
- [ ] Completed all items in this checklist
- [ ] Checked browser console (F12) for errors
- [ ] Checked PHP error logs
- [ ] Tested with demo data first
- [ ] Read README.md and QUICKSTART.md

## URLs to Bookmark

```
Admin Dashboard:
https://your-domain.com/digital-menu/admin/

TV Display (Board 1):
https://your-domain.com/digital-menu/display/?board=demo-main-board

API Test:
https://your-domain.com/digital-menu/api/get-menu.php?board=demo-main-board
```

---

## Quick Reference

**Default Board Slug:** `demo-main-board`  
**Default Refresh:** 30 seconds  
**Demo Items:** 7 items in 4 categories  
**API Method:** REST (GET/POST/PUT/DELETE)  
**Database:** MySQL with UTF-8  

---

**Status:** ⬜ Not Started | 🔄 In Progress | ✅ Complete | ❌ Issue

Last Updated: _______________  
Completed By: _______________
